-----------Disa System Pref data Part--------------
-----------Written by Carluz--------------
-----------Please contact me if you want to use this.--------------


local PrefPath = "Themes/".. THEME:GetThemeDisplayName() .."/UserPrefs/"

--------------Rem,of course-----------------------

------03 UserPreferences2.lua----------------------------------------------
local function WriteEnv(envName,envValue)
	return setenv(envName,envValue)
end

function ReadPrefFromFile(name)
	local f = RageFileUtil.CreateRageFile()
	local fullFilename = PrefPath..name..".cfg"
	local option

	if f:Open(fullFilename,1) then
		option = tostring( f:Read() )
		WriteEnv(name,option)
		f:destroy()
		return option
	else
		local fError = f:GetError()
		Trace( "[Preferences] Error reading ".. fullFilename ..": ".. fError )
		f:ClearError()
		f:destroy()
		return nil
	end
end

function WritePrefToFile(name,value)
	local f = RageFileUtil.CreateRageFile()
	local fullFilename = PrefPath..name..".cfg"

	if f:Open(fullFilename, 2) then
		f:Write( tostring(value) )
		WriteEnv(name,value)
	else
		local fError = f:GetError()
		Trace( "[Preferences] Error writing to ".. fullFilename ..": ".. fError )
		f:ClearError()
		f:destroy()
		return false
	end

	f:destroy()
	return true
end

--[[ end internal functions; still don't edit below this line ]]

function GetUserPref(name)
	return ReadPrefFromFile(name)
end

function SetUserPref(name,value)
	return WritePrefToFile(name,value)
end

--[[ type specific, for when you want to be lazy ]]
-- XXX: make set funcs, since I hate dealing with colors and I know
-- other themers would too.

-- GetUserPrefB: boolean
function GetUserPrefB(name)
	-- this one is a bit trickier.
	local pref = ReadPrefFromFile(name)

	if type(pref) == "string" then
		pref = string.lower(pref)
		if pref == "true" or cmp == "t" then
			return true
		elseif pref == "false" or cmp == "f" then
			return false
		else
			Trace("Error in GetUserPrefB(".. name ..") converting from string" )
			return false
		end
	elseif type(pref) == "number" then
		-- both 0 and -1 are false; if you want to change this, 
		-- feel free to remove "or pref == -1".
		if pref == 0 or pref == -1 then

		else
			return true
		end
	end
end

-- GetUserPrefC: color
function GetUserPrefC(name)
	-- XXX: make sure it's grabbing a string that can be turned into a color
	-- and also possibly handle HSV values too.
	return color( ReadPrefFromFile(name) )
end

-- GetUserPrefN: numbers (integers, floats)
function GetUserPrefN(name)
	return tonumber( ReadPrefFromFile(name) )
end


------03 UserPreferences2.lua,end---Yeah--------------------------------------------



function InitDisaPrefs()
	local DisaPrefs =
	{
		UseJacket = 'On',
		UseJacketOnWheel = 'On',
		UseTitleImg = 'On',
		DisaPoints = '0',
		SetTargetP1 = 'none',
		SetTargetP2 = 'none',
		UseFallBackTitleImage = 'On',
		GameplayBackground = 'Cover',
		IIDX15Explosion="_gold",
		IIDX15Turntable="_orange",
		UseFlashyLights = 'On'
	};
	for k, v in pairs(DisaPrefs) do
		if GetUserPref(k) == nil then
			SetUserPref(k, v)
			Trace("[Initialization: Initializing DisaPrefs]:"..k)
		end
	end
end

InitDisaPrefs();


------------------------------------------------------------------
function SetTarget()
	local t = {
		Name = "SetTarget",
		LayoutType = "ShowAllInRow",
		SelectType = "SelectOne",
		OneChoiceForAllPlayers = false,
		ExportOnChange = false,
		Choices = { '50%','60%','70%','80%','90%','95%','100%','none' },
		LoadSelections = function(self, list, pn)
			if (GetUserPref("SetTarget"..ToEnumShortString(pn))=='50%') then
				list[1] = true
			elseif (GetUserPref("SetTarget"..ToEnumShortString(pn))=='60%') then
				list[2] = true
			elseif (GetUserPref("SetTarget"..ToEnumShortString(pn))=='70%') then
				list[3] = true
			elseif (GetUserPref("SetTarget"..ToEnumShortString(pn))=='80%') then
				list[4] = true
			elseif (GetUserPref("SetTarget"..ToEnumShortString(pn))=='90%') then
				list[5] = true
			elseif (GetUserPref("SetTarget"..ToEnumShortString(pn))=='95%') then
				list[6] = true
			elseif (GetUserPref("SetTarget"..ToEnumShortString(pn))=='100%') then
				list[7] = true
			else
				list[8] = true
			end
		end;
		SaveSelections = function(self, list, pn)
			local val;
				if list[1] then 
					val='50%';
				elseif list[2] then 
					val='60%';
				elseif list[3] then 
					val='70%';
				elseif list[4] then 
					val='80%';
				elseif list[5] then 
					val='90%';
				elseif list[6] then 
					val='95%';
				elseif list[7] then 
					val='100%';
				else
					val='none';
				end;
			SetUserPref("SetTarget"..ToEnumShortString(pn), val)
			MESSAGEMAN:Broadcast("PreferenceSet", { Message == "Set Preference" })
			THEME:ReloadMetrics()
		end
	}
	setmetatable(t, t)
	return t
end

function UseFlashyLights()
	local t = {
		Name = "UseFlashyLights",
		LayoutType = "ShowAllInRow",
		SelectType = "SelectOne",
		OneChoiceForAllPlayers = true,
		ExportOnChange = false,
		Choices = { 'On','Off' },
		LoadSelections = function(self, list, pn)
			if (GetUserPref("UseFlashyLights")=='On') then
				list[1] = true
			else
				list[2] = true
			end
		end;
		SaveSelections = function(self, list, pn)
			local val;
			if list[1] then val='On'; else val='Off'; end;
			SetUserPref("UseFlashyLights", val)
			MESSAGEMAN:Broadcast("PreferenceSet", { Message == "Set Preference" })
			THEME:ReloadMetrics()
		end
	}
	setmetatable(t, t)
	return t
end

function GameplayBackground()
	local t = {
		Name = "GameplayBackground",
		LayoutType = "ShowAllInRow",
		SelectType = "SelectOne",
		OneChoiceForAllPlayers = true,
		ExportOnChange = false,
		Choices = { 'Cover','Fit' },
		LoadSelections = function(self, list, pn)
			if (GetUserPref("GameplayBackground")=='Cover') then
				list[1] = true
			else
				list[2] = true
			end
		end;
		SaveSelections = function(self, list, pn)
			local val;
			if list[1] then val='Cover'; else val='Fit'; end;
			SetUserPref("GameplayBackground", val)
			MESSAGEMAN:Broadcast("PreferenceSet", { Message == "Set Preference" })
			THEME:ReloadMetrics()
		end
	}
	setmetatable(t, t)
	return t
end

function UseFallBackTitleImage()
	local t = {
		Name = "UseFallBackTitleImage",
		LayoutType = "ShowAllInRow",
		SelectType = "SelectOne",
		OneChoiceForAllPlayers = true,
		ExportOnChange = false,
		Choices = { 'On','Off' },
		LoadSelections = function(self, list, pn)
			if (GetUserPref("UseFallBackTitleImage")=='On') then
				list[1] = true
			else
				list[2] = true
			end
		end;
		SaveSelections = function(self, list, pn)
			local val;
			if list[1] then val='On'; else val='Off'; end;
			SetUserPref("UseFallBackTitleImage", val)
			MESSAGEMAN:Broadcast("PreferenceSet", { Message == "Set Preference" })
			THEME:ReloadMetrics()
		end
	}
	setmetatable(t, t)
	return t
end

function UseJacket()
	local t = {
		Name = "UseJacket",
		LayoutType = "ShowAllInRow",
		SelectType = "SelectOne",
		OneChoiceForAllPlayers = true,
		ExportOnChange = false,
		Choices = { 'On','Off' },
		LoadSelections = function(self, list, pn)
			if (GetUserPref("UseJacket")=='On') then
				list[1] = true
			else
				list[2] = true
			end
		end;
		SaveSelections = function(self, list, pn)
			local val;
			if list[1] then val='On'; else val='Off'; end;
			SetUserPref("UseJacket", val)
			MESSAGEMAN:Broadcast("PreferenceSet", { Message == "Set Preference" })
			THEME:ReloadMetrics()
		end
	}
	setmetatable(t, t)
	return t
end

function UseJacketOnWheel()
	local t = {
		Name = "UseJacketOnWheel",
		LayoutType = "ShowAllInRow",
		SelectType = "SelectOne",
		OneChoiceForAllPlayers = true,
		ExportOnChange = false,
		Choices = { 'On','Off' },
		LoadSelections = function(self, list, pn)
			if (GetUserPref("UseJacketOnWheel")=='On') then
				list[1] = true
			else
				list[2] = true
			end
		end;
		SaveSelections = function(self, list, pn)
			local val;
			if list[1] then val='On'; else val='Off'; end;
			SetUserPref("UseJacketOnWheel", val)
			MESSAGEMAN:Broadcast("PreferenceSet", { Message == "Set Preference" })
			THEME:ReloadMetrics()
		end
	}
	setmetatable(t, t)
	return t
end

function UseTitleImg()
	local t = {
		Name = "UseTitleImg",
		LayoutType = "ShowAllInRow",
		SelectType = "SelectOne",
		OneChoiceForAllPlayers = true,
		ExportOnChange = false,
		Choices = { 'On','Off' },
		LoadSelections = function(self, list, pn)
			if (GetUserPref("UseTitleImg")=='On') then
				list[1] = true
			else
				list[2] = true
			end
		end;
		SaveSelections = function(self, list, pn)
			local val;
			if list[1] then val='On'; else val='Off'; end;
			SetUserPref("UseTitleImg", val)
			MESSAGEMAN:Broadcast("PreferenceSet", { Message == "Set Preference" })
			THEME:ReloadMetrics()
		end
	}
	setmetatable(t, t)
	return t
end

function OptionRowScreenFilter()
	local t = {
		Name="ScreenFilter",
		LayoutType = "ShowAllInRow",
		SelectType = "SelectOne",
		OneChoiceForAllPlayers = false,
		ExportOnChange = false,
		Choices = { THEME:GetString('OptionNames','Off'), '0.1', '0.2', '0.3', '0.4', '0.5', '0.6', '0.7', '0.8', '0.9', '1.0', },
		LoadSelections = function(self, list, pn)
			local pName = ToEnumShortString(pn)
			local filterValue = getenv("ScreenFilter"..pName)
			if filterValue ~= nil then
				local val = scale(tonumber(filterValue),0,1,1,#list )
				list[val] = true
			else
				setenv("ScreenFilter"..pName,0)
				list[1] = true
			end
		end,
		SaveSelections = function(self, list, pn)
			local pName = ToEnumShortString(pn)
			local found = false
			for i=1,#list do
				if not found then
					if list[i] == true then
						local val = scale(i,1,#list,0,1)
						setenv("ScreenFilter"..pName,val)
						found = true
					end
				end
			end
		end,
	};
	setmetatable(t, t)
	return t
end

-- protiming
function OptionRowProTiming()
	local t = {
		Name = "ProTiming",
		LayoutType = "ShowAllInRow",
		SelectType = "SelectOne",
		OneChoiceForAllPlayers = false,
		ExportOnChange = false,
		Choices = {
			THEME:GetString('OptionNames','Off'),
			THEME:GetString('OptionNames','On')
		},
		LoadSelections = function(self, list, pn)
			if GetUserPrefB("UserPrefProtiming" .. ToEnumShortString(pn)) then
				local bShow = GetUserPrefB("UserPrefProtiming" .. ToEnumShortString(pn))
				if bShow then
					list[2] = true
				else
					list[1] = true
				end
			else
				list[1] = true
			end
		end,
		SaveSelections = function(self, list, pn)
			local bSave = list[2] and true or false
			SetUserPref("UserPrefProtiming" .. ToEnumShortString(pn), bSave)
		end
	}
	setmetatable(t, t)
	return t
end